-- PaneDisplay.
-- shows up when SSMusicInfo is set to PaneDisplay.
local bWarningDisplayed = false;

local pd = Def.ActorFrame{
	Name="PaneDisplaySection";
	InitCommand=cmd(x,-64);
};

-- player stuff is out back

local numPlayers = GAMESTATE:GetNumSidesJoined();
local panes = Def.ActorFrame{ }; -- panes!!
local rv;

local headerWidth = 240;
if numPlayers == 2 then
	headerWidth = (headerWidth / 2)-2;
end;

local paneCategories = {
	'RadarCategory_TapsAndHolds',
	'RadarCategory_Jumps',
	'RadarCategory_Holds',
	'RadarCategory_Mines',
	'RadarCategory_Hands',
	'RadarCategory_Rolls'
};

local paneStrings = {
	THEME:GetString("RadarCategory","Taps"),
	THEME:GetString("RadarCategory","Jumps"),
	THEME:GetString("RadarCategory","Holds"),
	THEME:GetString("RadarCategory","Mines"),
	THEME:GetString("RadarCategory","Hands"),
	THEME:GetString("RadarCategory","Rolls")
};

if numPlayers == 1 then
	-- single player
	local player = GAMESTATE:GetMasterPlayerNumber();

	panes[#panes+1] = Def.ActorFrame{
		Name="Frame"..player;
		InitCommand=cmd(x,80);

		LoadActor( THEME:GetPathB("","_frame 3x3"), "_square blackinset transparent normal", headerWidth-2, 80)..{
			InitCommand=cmd(y,56);
		};

		LoadActor( THEME:GetPathB("","_frame 3x1"), "_infobox header", headerWidth )..{
			Name="Header"..player;
			InitCommand=cmd(diffuse,PlayerColor(player);y,-5);
		};

		AutoText("frutiger")..{
			InitCommand=cmd(shadowlength,1;zoom,0.55;y,-5;NoStroke);
			BeginCommand=function(self)
				self:settext( playername(player).." Information" );
			end;
		};
	};

	for i=1,#paneCategories do
		panes[#panes+1] = Def.ActorFrame{
			Name=player..paneStrings[i];
			InitCommand=cmd(y,(i)*16);

			AutoText("frutiger")..{
				Text=paneStrings[i];
				InitCommand=cmd(shadowlength,1;horizalign,right;zoom,0.55;NoStroke);
			};

			AutoText("frutiger")..{
				InitCommand=cmd(x,8;shadowlength,1;horizalign,left;zoom,0.55;NoStroke;playcommand,"Set");

				SetCommand=function(self)
					local song;
					local steps;
					if GAMESTATE:IsCourseMode() then
						song = GAMESTATE:GetCurrentCourse();
						steps = GAMESTATE:GetCurrentTrail(player);
					else
						song = GAMESTATE:GetCurrentSong();
						steps = GAMESTATE:GetCurrentSteps(player);
					end;

					if not song then self:visible(false);
					else self:visible(true);
					end;

					if steps then
						rv = steps:GetRadarValues(player);
						local val = rv:GetValue(paneCategories[i]);
						self:settext( val );
						if val == 0 then
							self:diffusealpha(0.5);
						else
							self:diffusealpha(1);
						end;
					elseif song and not steps then
						-- this is an interesting one. we should probably tell
						-- players to restart StepMania. Remove this later, if
						-- this specific instance is removed.
						--[[
						if not bWarningDisplayed then
							if not GAMESTATE:IsCourseMode() then
								SCREENMAN:SystemMessage("You should probably restart StepMania before a crash happens.");
								bWarningDisplayed = true;
							end;
						end;
						]]
						-- make it distinct (and a reference to WWF No Mercy :p)
						self:settext("RROR");
					else
						self:settext("ERROR");
					end;
				end;

				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");

				CurrentStepsP1ChangedMessageCommand=function(self)
					if player == PLAYER_1 then self:playcommand("Set"); end;
				end;
				CurrentTrailP1ChangedMessageCommand=function(self)
					if player == PLAYER_1 then self:playcommand("Set"); end;
				end;
				CurrentStepsP2ChangedMessageCommand=function(self)
					if player == PLAYER_2 then self:playcommand("Set"); end;
				end;
				CurrentTrailP2ChangedMessageCommand=function(self)
					if player == PLAYER_2 then self:playcommand("Set"); end;
				end;
			};
		};
	end;
else
	-- two players

	for pi, player in pairs(PlayerNumber) do
		panes[#panes+1] = Def.ActorFrame{
			Name="Frame"..playername(player);
			InitCommand=function(self)
				if player == PLAYER_1 then self:x(8);
				else self:x(152);
				end;
			end;

			LoadActor( THEME:GetPathB("","_frame 3x3"), "_square blackinset transparent normal", headerWidth-2, 80)..{
				InitCommand=cmd(y,56);
			};

			LoadActor( THEME:GetPathB("","_frame 3x1"), "_infobox header", headerWidth )..{
				Name="Header"..playername(player);
				InitCommand=cmd(diffuse,PlayerColor(player);y,-5);
			};

			AutoText("frutiger")..{
				InitCommand=cmd(shadowlength,1;zoom,0.55;NoStroke;y,-5);
				BeginCommand=function(self)
					self:settext (playername(player).." Information" );
				end;
			};
		};

		for i=1,#paneCategories do
		panes[#panes+1] = Def.ActorFrame{
			Name=player..paneStrings[i];
			InitCommand=cmd(y,(i)*16);

			AutoText("frutiger")..{
				Text=paneStrings[i];
				InitCommand=cmd(shadowlength,1;horizalign,right;NoStroke;zoom,0.55);
				BeginCommand=function(self)
					if player == PLAYER_1 then self:x(0);
					else self:x(144);
					end;
				end;
			};

			AutoText("frutiger")..{
				InitCommand=cmd(shadowlength,1;horizalign,left;zoom,0.55;NoStroke;playcommand,"Set");
				BeginCommand=function(self)
					if player == PLAYER_1 then self:x(8);
					else self:x(152);
					end;
				end;

				SetCommand=function(self)
					local song;
					local steps;
					if GAMESTATE:IsCourseMode() then
						song = GAMESTATE:GetCurrentCourse();
						steps = GAMESTATE:GetCurrentTrail(player);
					else
						song = GAMESTATE:GetCurrentSong();
						steps = GAMESTATE:GetCurrentSteps(player);
					end;

					if not song then self:visible(false);
					else self:visible(true);
					end;

					if steps then
						rv = steps:GetRadarValues(player);
						local val = rv:GetValue(paneCategories[i]);
						self:settext( val );
						if val == 0 then
							self:diffusealpha(0.5);
						else
							self:diffusealpha(1);
						end;
					else
						self:settext("");
					end;
				end;

				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");

				CurrentStepsP1ChangedMessageCommand=function(self)
					if player == PLAYER_1 then self:playcommand("Set"); end;
				end;
				CurrentTrailP1ChangedMessageCommand=function(self)
					if player == PLAYER_1 then self:playcommand("Set"); end;
				end;
				CurrentStepsP2ChangedMessageCommand=function(self)
					if player == PLAYER_2 then self:playcommand("Set"); end;
				end;
				CurrentTrailP2ChangedMessageCommand=function(self)
					if player == PLAYER_2 then self:playcommand("Set"); end;
				end;
			};
		};
		end;
	end;
end;

pd[#pd+1] = panes;

return pd;